library("gplots")
cccol <- c("#CE0013","#16557A","#C7A609","#87C232","#64C0AB","#A14C94","#15A08C","#8B7E75","#1E7CAF","#EA425F","#46489A","#E50033","#0F231F","#1187CD")

n_log2fpkm <- read.table("../data/2nd.reprogramming.lg2.all.fpkm.txt",header=T,row.names=1)
p_log2fpkm <- read.table("../data/paper.reprogramming.lg2.all.fpkm.txt",header=T,row.names=1)
n_fpkm <- round(2**n_log2fpkm-1,5)
p_fpkm <- round(2**p_log2fpkm-1,5)

dev_fpkm <- read.table("../data/nsmb.2660-S2.txt",header=T,row.names=1)
colnames(dev_fpkm) <- c("Oocyte_1","Oocyte_2","Oocyte_3","Zygote_1","Zygote_2","Zygote_3",
     "X2cell_e1_C1","X2cell_e1_C2","X2cell_e2_C1","X2cell_e2_C2","X2cell_e3_C1","X2cell_e3_C2",
     "X4cell_e1_C1","X4cell_e1_C2","X4cell_e1_C3","X4cell_e1_C4","X4cell_e2_C1","X4cell_e2_C2",
     "X4cell_e2_C3","X4cell_e2_C4","X4cell_e3_C1","X4cell_e3_C2","X4cell_e3_C3","X4cell_e3_C4",
     "X8cell_e1_C1","X8cell_e1_C2","X8cell_e1_C3","X8cell_e1_C4","X8cell_e2_C1","X8cell_e2_C2",
     "X8cell_e2_C3","X8cell_e2_C4","X8cell_e2_C5","X8cell_e2_C6","X8cell_e2_C7","X8cell_e2_C8",
     "X8cell_e3_C1","X8cell_e3_C2","X8cell_e3_C3","X8cell_e3_C4","X8cell_e3_C5","X8cell_e3_C6",
     "X8cell_e3_C7","X8cell_e3_C8","Morulae_1_C1","Morulae_1_C2","Morulae_1_C3","Morulae_1_C4",
     "Morulae_1_C5","Morulae_1_C6","Morulae_1_C7","Morulae_1_C8","Morulae_2_C1","Morulae_2_C2",
     "Morulae_2_C3","Morulae_2_C4","Morulae_2_C5","Morulae_2_C6","Morulae_2_C7","Morulae_2_C8",
     "Late_blastocyst_1_C1","Late_blastocyst_1_C2","Late_blastocyst_1_C3","Late_blastocyst_1_C4",
     "Late_blastocyst_1_C5","Late_blastocyst_1_C6","Late_blastocyst_1_C7","Late_blastocyst_1_C8",
     "Late_blastocyst_1_C9","Late_blastocyst_1_C10","Late_blastocyst_1_C11","Late_blastocyst_1_C12",
     "Late_blastocyst_2_C1","Late_blastocyst_2_C2","Late_blastocyst_2_C3","Late_blastocyst_2_C4",
     "Late_blastocyst_2_C5","Late_blastocyst_2_C6","Late_blastocyst_2_C7","Late_blastocyst_2_C8",
     "Late_blastocyst_2_C9","Late_blastocyst_2_C10","Late_blastocyst_3_C1","Late_blastocyst_3_C2",
     "Late_blastocyst_3_C3","Late_blastocyst_3_C4","Late_blastocyst_3_C5","Late_blastocyst_3_C6",
     "Late_blastocyst_3_C7","Late_blastocyst_3_C8","hESC_passage0_C1","hESC_passage0_C2","hESC_passage0_C3",
     "hESC_passage0_C4","hESC_passage0_C5","hESC_passage0_C6","hESC_passage0_C7","hESC_passage0_C8","hESC_passage10_C1",
     "hESC_passage10_C2","hESC_passage10_C3","hESC_passage10_C4","hESC_passage10_C5","hESC_passage10_C6","hESC_passage10_C7",
     "hESC_passage10_C8","hESC_passage10_C9","hESC_passage10_C10","hESC_passage10_C11","hESC_passage10_C12","hESC_passage10_C13",
     "hESC_passage10_C14","hESC_passage10_C15","hESC_passage10_C16","hESC_passage10_C17","hESC_passage10_C18","hESC_passage10_C19",
     "hESC_passage10_C20","hESC_passage10_C21","hESC_passage10_C22","hESC_passage10_C23","hESC_passage10_C24","hESC_passage10_C25",
     "hESC_passage10_C26","Average_Oocyte","Average_Zygote","Average_X2cell_e","Average_X4cell_e","Average_X8cell_e","Average_Morulae",
     "Average_Trophectoderm","Average_Primitive_endoderm","Average_epiblast","Average_hESC_passage0","Average_hESC_passage10",
     "FCTrophectoderm_epiblast_Primitive_endoderm","PvalueTrophectoderm_epiblast_Primitive_endoderm","FCepiblast_Trophectoderm",
     "Pvalueepiblast_Trophectoderm","FCepiblast_Primitive_endoderm","Pvalueepiblast_Primitive_endoderm","FCepiblast_hESC_passage0",
     "Pvalueepiblast_hESC_passage0","FChESC_passage0_hESC_passage10","PvaluehESC_passage0_hESC_passage10")

# plot_genes <- intersect(intersect(rownames(n_fpkm),rownames(p_fpkm)),rownames(dev_fpkm))
# plot_genes <- read.table("/mnt/Storage3/home/zhaocc/Work/1.naiveiPS/result/A2.gene.clustering/11-genes-cor.txt")[,1]
plot_genes <- c("DNMT3L","DPPA2","DPPA3","DPPA5","KLF2","KLF5","TFCP2L1","ALPPL2","ZFP57","FGF4","NLRP7")
plot_genes <- intersect(plot_genes,rownames(dev_fpkm))

plot_data <- cbind(n_fpkm[plot_genes,c("n24p_r1","n24p_r2","n24m_r1","n24m_r2","niPS_r1","niPS_r2")],
	p_fpkm[plot_genes,c("d24p_pTRA_r1","d24p_pTRA_r3","d24p_pTRA_r4","d24m_pTRA_r1","d24m_pTRA_r2","d24m_pTRA_r3","d24m_pTRA_r4","hiPST_MTG_r1","hiPST_MTG_r2","hiPST_VTN_r1","hiPST_VTN_r2")],
	dev_fpkm[plot_genes,c("Late_blastocyst_2_C4","Late_blastocyst_2_C5","Late_blastocyst_2_C6","Late_blastocyst_2_C7")])
colnames(plot_data) <- c("n24d+dox_r1","n24d+dox_r2","n24d-dox_r1","n24d-dox_r2","niPSC-T_r1","niPSC-T_r2","p24d+dox_r1","p24d+dox_r2","p24d+dox_r3","p24d-dox_r1","p24d-dox_r2","p24d-dox_r3","p24d-dox_r4","piPSC-T_r1","piPSC-T_r2","piPSC-T_r3","piPSC-T_r4","ICM_r1","ICM_r2","ICM_r3","ICM_r4")

pdf("SFig2C.pdf",width=6,height=6)
sample_cor <- cor(plot_data)
# cor_cell <- matrix(as.character(round(sample_cor, 2)), ncol=dim(sample_cor)[2])
heatmap.2(sample_cor,trace="none",margins=c(8.0,8.0), cexRow=0.8, cexCol=0.8, revC=T, symm=T)
dev.off()
